﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;

namespace SWAT_Office_App
{
    public partial class Menu_Main_Form : Form
    {
        public Menu_Main_Form()
        {
            Debug.startNewSession();
            Settings_Form.ImportSettings();
            Stat_Logging.ImportSettings();
            InitializeComponent();
            this.KeyPress += new KeyPressEventHandler(Menu_Main_KeyPress);
            this.FormClosing += new FormClosingEventHandler(Menu_Main_FormClosing);
        }

        void Menu_Main_FormClosing(object sender, FormClosingEventArgs e)
        {
            Stat_Logging.ExportSettings();
        }
        void Menu_Main_KeyPress(object sender, KeyPressEventArgs e)
        {
            // Monitors for keypresses
            switch (e.KeyChar)
            {
                case '1':   // Manage User Accounts and Shares
                    Manage_User_Accounts_Form user_Mgmt = new Manage_User_Accounts_Form();
                    user_Mgmt.ShowDialog();
                    break;
                case '2':   // DriveLogger
                    // Check to make sure that an instance of DriveLogger isnt already running
                    if (!DriveLogger_Form.instanceAlreadyRunning)
                    {
                        Debug.appendText("Starting instance of DriveLogger");
                        DriveLogger_Form driveForm = new DriveLogger_Form();
                        driveForm.Show();
                    }
                    else
                    {
                        MessageBox.Show("An instance of DriveLogger is already running");
                    }
                    break;
                case '3':   // Reimage USB Drives
                    // Check to make sure that another imaging thread isnt running
                    if (!Reimage_USB_Drives.threadsRunning)
                    {
                        Debug.appendText("Starting reimaging of USB drives");
                        Reimage_USB_Drives.reimageUSBDrives();
                    }
                    else
                        MessageBox.Show("Another file copy operation is currently in progress.\n" +
                                        "Please wait for transfer to finish before starting another");
                    break;
                case '4':   // Program Settings
                    Settings_Verify_Form settingsForm = new Settings_Verify_Form();
                    settingsForm.ShowDialog();
                    break;
                case '?':   // About
                    About_Box_Form aboutForm = new About_Box_Form();
                    aboutForm.ShowDialog();
                    break;
            }
        }
        private void btn_Main_UserMgmt_Click(object sender, EventArgs e)
        {
            // Manage User Accounts and Shares
            Manage_User_Accounts_Form userMgmtForm = new Manage_User_Accounts_Form();
            userMgmtForm.ShowDialog();
        }
        private void btn_DriveLogger_Click(object sender, EventArgs e)
        {
            // DriveLogger
            if (!DriveLogger_Form.instanceAlreadyRunning)
            {
                Debug.appendText("Starting instance of DriveLogger");
                DriveLogger_Form driveForm = new DriveLogger_Form();
                driveForm.Show();
            }
            else
                MessageBox.Show("An instance of DriveLogger is already running");
        }
        private void btn_Reimage_USB_Drives_Click(object sender, EventArgs e)
        {
            // Reimage USB Drives
            if (!Reimage_USB_Drives.threadsRunning)
            {
                Debug.appendText("Starting reimaging of USB drives");
                Reimage_USB_Drives.reimageUSBDrives();
            }
            else
                MessageBox.Show("Another file copy operation is currently in progress.\n" +
                                "Please wait for transfer to finish before starting another");
        }
        private void btn_Main_Settings_Click(object sender, EventArgs e)
        {
            // Program Settings
            Settings_Verify_Form settingsForm = new Settings_Verify_Form();
            settingsForm.ShowDialog();
        }
    }
}
